"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sharedLicenseStatuses = void 0;
exports.useLicenseVerifier = useLicenseVerifier;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var React = _interopRequireWildcard(require("react"));
var _verifyLicense = require("../verifyLicense/verifyLicense");
var _licenseInfo = require("../utils/licenseInfo");
var _licenseErrorMessageUtils = require("../utils/licenseErrorMessageUtils");
var _licenseStatus = require("../utils/licenseStatus");
var _LicenseInfoContext = _interopRequireDefault(require("../Unstable_LicenseInfoProvider/LicenseInfoContext"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const sharedLicenseStatuses = {};
exports.sharedLicenseStatuses = sharedLicenseStatuses;
function useLicenseVerifier(packageName, releaseInfo) {
  const {
    key: contextKey
  } = React.useContext(_LicenseInfoContext.default);
  return React.useMemo(() => {
    const licenseKey = contextKey ?? _licenseInfo.LicenseInfo.getLicenseKey();

    // Cache the response to not trigger the error twice.
    if (sharedLicenseStatuses[packageName] && sharedLicenseStatuses[packageName].key === licenseKey) {
      return sharedLicenseStatuses[packageName].licenseVerifier;
    }
    const acceptedScopes = packageName.includes('premium') ? ['premium'] : ['pro', 'premium'];
    const plan = packageName.includes('premium') ? 'Premium' : 'Pro';
    const licenseStatus = (0, _verifyLicense.verifyLicense)({
      releaseInfo,
      licenseKey,
      acceptedScopes
    });
    sharedLicenseStatuses[packageName] = {
      key: licenseKey,
      licenseVerifier: licenseStatus
    };
    const fullPackageName = `@mui/${packageName}`;
    if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.Valid) {
      // Skip
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.Invalid) {
      (0, _licenseErrorMessageUtils.showInvalidLicenseKeyError)();
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.OutOfScope) {
      (0, _licenseErrorMessageUtils.showLicenseKeyPlanMismatchError)();
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.NotFound) {
      (0, _licenseErrorMessageUtils.showMissingLicenseKeyError)({
        plan,
        packageName: fullPackageName
      });
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.ExpiredAnnualGrace) {
      (0, _licenseErrorMessageUtils.showExpiredAnnualGraceLicenseKeyError)((0, _extends2.default)({
        plan
      }, licenseStatus.meta));
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.ExpiredAnnual) {
      (0, _licenseErrorMessageUtils.showExpiredAnnualLicenseKeyError)((0, _extends2.default)({
        plan
      }, licenseStatus.meta));
    } else if (licenseStatus.status === _licenseStatus.LICENSE_STATUS.ExpiredVersion) {
      (0, _licenseErrorMessageUtils.showExpiredPackageVersionError)({
        packageName: fullPackageName
      });
    } else if (process.env.NODE_ENV !== 'production') {
      throw new Error('missing status handler');
    }
    return licenseStatus;
  }, [packageName, releaseInfo, contextKey]);
}